"""
Ping handler for daemon connectivity checks.

Responds to /live/ping with /live/pong, allowing the daemon to verify
that the Grip script is loaded and responsive.
"""

import time
from .handler import GripHandler


class PingHandler(GripHandler):
    def __init__(self, manager):
        super().__init__(manager)
        self.class_identifier = "ping"

    def init_api(self):
        self.osc_server.add_handler("/live/ping", self._handle_ping)

    def _handle_ping(self, params):
        """
        Responds to ping with pong and server timestamp.
        Daemon can measure round-trip latency.
        """
        self.osc_server.send("/live/pong", (time.time(),))
        return None
